<div class="alert alert-info">
    <i class="fa fa-info"></i>

	<?php
    // The base url is the url where we'll pass the filter parameters
    $base_url = array('controller' => 'stats', 'action' => 'device');
    echo $this->Form->create('Filter', array(
        'url' => $base_url,
        'class' => 'form-inline',
        'inputDefaults' => array(
            //'label' => false,
            'div' => 'form-group',
            'class' => 'form-control input-sm',
            'error' => array(
                'attributes' => array('wrap' => 'span', 'class' => 'help-block')
            ),
        ),
    ));
    ?>

    <?php echo $this->Form->input('date_from', array('type' => 'date', 'placeholder' => __('From'), 'minYear' => date('Y') - 3, 'maxYear' => date('Y'))); ?>

    <?php echo $this->Form->input('date_to', array('type' => 'date', 'placeholder' => __('To'), 'minYear' => date('Y') - 3, 'maxYear' => date('Y'))); ?>

    <?php echo $this->Form->submit('Filter', array('div' => false, 'class' => 'btn btn-default btn-sm')); ?>
    <?php echo $this->Html->link('Reset', $base_url); ?>
    <?php echo $this->Form->end(); ?>

</div>


<div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Devices</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-8">
                        <div id="devices_donut" style="position: relative; height: 300px; width: 100%;"></div>
                    </div>
                    <div class="col-sm-4" style="height: 300px;overflow: auto;">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Domain</th>
                                    <th>Clicks</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($link_devices as $link_device) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $link_device['Stat']['device_type'];
                                    echo '</td>';
                                    echo '<td>';
                                    echo $link_device[0]['num'];
                                    echo '</td>';
                                    echo '</tr>';
                                }
                                unset($link_device);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

<script>

    jQuery(document).ready(function () {

        /**
         * devices Type
         */

        new Morris.Donut({
            element: 'devices_donut',
            resize: true,
            data: [
<?php
foreach ($link_devices as $link_device) {
    echo '{label: "' . $link_device['Stat']["device_type"] . '", value: ' . $link_device[0]["num"] . '},';
}
unset($link_device);
?>
            ],
            smooth: false
        });



    });
</script>
